<?php
@session_start();
$permitted_chars = 'ABCDEFGHJKLMNPQRSTUVWXYZ23456789';
function generate_string($input, $length = 4) {
    $input_length = strlen($input);
    $random_string = '';
    for ($i = 0; $i < $length; $i++) {
        $random_character = $input[mt_rand(0, $input_length - 1)];
        $random_string .= $random_character;
    }
    
    return $random_string;
}
$width = 200;
$height = 60;
$image = imagecreatetruecolor($width, $height);
imageantialias($image, true);
$red   = rand(100, 255);
$green = rand(100, 255);
$blue  = rand(100, 255);
$background_color = imagecolorallocate($image, $red, $green, $blue);
imagefill($image, 0, 0, $background_color);
for ($i = 0; $i < 6; $i++) {
    $line_color = imagecolorallocate($image, rand(50,200), rand(50,200), rand(50,200));
    imagearc($image, rand(0, $width), rand(0, $height), rand(30, 300), rand(20, 200),
        rand(0, 360), rand(0, 360), $line_color);
}
for ($i = 0; $i < 400; $i++) {
    $noise_color = imagecolorallocate($image, rand(0,255), rand(0,255), rand(0,255));
    imagesetpixel($image, rand(0, $width), rand(0, $height), $noise_color);
}
$fonts = [
    dirname(dirname(dirname(dirname(dirname(__DIR__)))))."/third/barcodegen/class/font/Arial.ttf",
    dirname(dirname(dirname(dirname(dirname(__DIR__)))))."/third/barcodegen/class/font/Courier.ttf",
    dirname(dirname(dirname(dirname(dirname(__DIR__)))))."/third/barcodegen/class/font/Times.ttf",
    dirname(dirname(dirname(dirname(dirname(__DIR__)))))."/third/barcodegen/class/font/Verdana.ttf"
];
$string_length = 4;
$captcha_string = generate_string($permitted_chars, $string_length);
$_SESSION['nm_session']['prod_v8']['login']['captcha_text'] = $captcha_string;
for ($i = 0; $i < $string_length; $i++) {
    $font_size = rand(22, 28);
    $angle = rand(-25, 25);
    $x = 20 + ($i * 35);
    $y = rand(35, 55);

    $text_color = imagecolorallocate($image, rand(0,150), rand(0,150), rand(0,150));
    $font = $fonts[array_rand($fonts)];

    imagettftext($image, $font_size, $angle, $x, $y, $text_color, $font, $captcha_string[$i]);
}
header('Content-type: image/png');
imagepng($image);
imagedestroy($image);